#!/usr/bin/env python

#    Copyright (C) 2008  Evan Broder <broder@mit.edu>
#	 Copyright (C) 2001	 Jeff Epler	 <jepler@unpythonic.dhs.org>
#	 Copyright (C) 2006	 Csaba Henk	 <csaba.henk@creo.hu>
#
#	 This program can be distributed under the terms of the GNU LGPL.
#

import os, sys
from errno import *
from stat import *
import fcntl
import fuse
import pwd
from fuse import Fuse

if not hasattr(fuse, '__version__'):
	raise RuntimeError, \
		"your fuse-py doesn't know of fuse.__version__, probably it's too old."

fuse.fuse_python_api = (0, 2)

class ErrorFS(Fuse):

	def __init__(self, *args, **kw):

		Fuse.__init__(self, *args, **kw)

		self.root = '/tmp/errors'
		self.global_log = open(os.path.join(self.root, 'global'), 'a')
	
	def getRealPath(self, path):
		if path == '/':
			return self.root
		uid = fuse.FuseGetContext()['uid']
		username = pwd.getpwuid(uid).pw_name
		realPath = os.path.join(self.root, username)
		open(realPath, 'w')
		
		return realPath

	def getattr(self, path):
		realPath = self.getRealPath(path)
		return os.lstat(self.getRealPath(path))

	def readdir(self, path, offset):
		yield fuse.Direntry('error_log')

	def utime(self, path, times):
		os.utime(self.getRealPath(path), times)

	def access(self, path, mode):
		if not os.access(self.getRealPath(path), mode):
			return -EACCES

	def fsinit(self):
		os.chdir(self.root)

	def read(self, path, length, offset):
		f = file(self.getRealPath(path))
		f.seek(offset)
		return f.read(length)
	
	def write(self, path, buf, offset):
		f = open(self.getRealPath(path), 'a')
		f.write(buf)
		f.close()
		
		self.global_file.write(buf)
		
		return len(buf)
	
	def truncate(self, path, len):
		return

def main():

	usage = """
Userspace nullfs-alike: mirror the filesystem tree from some point on.

""" + Fuse.fusage

	server = ErrorFS(version="%prog " + fuse.__version__,
				 usage=usage,
				 dash_s_do='setsingle')

	server.parser.add_option(mountopt="root", metavar="PATH", default='/tmp/errors',
							 help="mirror filesystem from under PATH [default: %default]")
	server.parse(values=server, errex=1)

	try:
		if server.fuse_args.mount_expected():
			os.chdir(server.root)
	except OSError:
		print >> sys.stderr, "can't enter root of underlying filesystem"
		sys.exit(1)

	server.main()


if __name__ == '__main__':
	main()
