<?php error_reporting(E_ALL ^ E_NOTICE);
/**
* physicsMITformMail script - sending mail via form
*
*     Author: Kimeee Heatley
*      Email: kheatley@mit.edu
*        Web: http://web.mit.edu/physics/
*    Details: Php code to send form data to us and submitter and also to .csv file.
*
* Please direct bug reports,suggestions or feedback to our webmaster.
* Kimeee Heatley at kheatley@mit.edu
*                                                                          
* MITformMail is free for both commercial and non-commercial use.
* Re-distribution of this script without prior consent is strictly prohibited.
*                                                                                 
*/

/*****************************************************************************
 *                                                                           *
 *                C  O  N  F  I  G  U  R  A  T  I  O  N                      *
 *                                                                           *
 *****************************************************************************/

// email for send submitted forms //////////////////////////////////////////
// if empty, use value from form ('send_to' field)
$send_to = 'Carol Breen <breen@mit.edu>';
//$send_to = 'Kimeee Heatley <kheatley@mit.edu>';

// set $send_cc address if you need copy of mail to other addresses
// for example: $send_cc = array('friend1@ccc.cc', 'friend2@ccc.cc'); 
//
$send_cc = array('kheatley@mit.edu'); 

// Subject. if empty, use value from form ('subject' field)
$subject = 'MIT Pappalardo Fellowship Competition 2019-2022 Nomination Submission ';

// Allowed Referres. Should be empty or list of domains
$referrers = array(); 

// Attachments
$attachment_enabled = 0;

////// Database - write CSV file with data of submitted forms //////////////
$database_enabled = 1;
$database_file = 'pappalardo2019-2022.csv';

// Fields to collect
// $database_fields = '*' - mean all fields, as in form
// $database_fields = array('from', 'subject') - only 'from', 'subject' fields
	
$database_fields = array('nomineeGender_req','nomineeFName_req', 'nomineeLName_req','nomineeInstitution_req', 'nomineeDept_req', 'nomineeField_req', 'nomineePhd_req', 'nomineeAddy_req', 'nomineePhone_req', 'nomineeEmail_req', 'nominatorTitle_req', 'nominatorFName_req', 'nominatorLName_req','nominatorInstitution_req', 'nominatorDept_req', 'nominatorAddy_req', 'nominatorPhone_req', 'nominatorEmail_req'); 
	
//$verify = "http://scripts.mit.edu/~physics/verify_nomination.php?var1='%nominatorName_req%'&var2='%nominatorEmail_req%'&var3='%nomineeName_req%'";

$verify = 'https://physics.scripts.mit.edu/verify_nomination.php?var1=%nominatorEmail_req%&var2=%nominatorFName_req%&var3=%nominatorLName_req%&var4=%nomineeFName_req%&var5=%nomineeLName_req%';

$nominatorFullName = '%nominatorFName_req%' . ' ' . '%nominatorLName_req%';
$nomineeFullName = '%nomineeFName_req%' . ' ' . '%nomineeLName_req%';

//$verify = 'http://scripts.mit.edu/~physics/verify_nomination.php?var1=%nominatorName_req%&var2=%nominatorEmail_req%&var3=%nomineeName_req%';

////// Redirect user after submitting form 
$redirect_url = 'http://web.mit.edu/physics/research/pappalardo/confirmation_1of2.html';

/* Now we are ready to send the email so we call phps mail() function
with the appropriate variables from above included in the brackets */

////// Auto-Responder
////// You can substitute any of form fields in response by using
////// %field_name% in response text.
//////
$date_time = date('Y-m-d H:i:s');
$autoresponder_enabled = 1;
$autoresponder_from = $send_to;
$autoresponder_subject = $subject;
$autoresponder_message = <<<MSG
Dear %nominatorFName_req% %nominatorLName_req%,\n
Thank you for your nomination for the 2019-2022 MIT Pappalardo Fellowships competition. \n
Please review your submitted information below.  If the information is correct, please click the link at the bottom of this email to verify.\n
Sincerely,\n
Carol Breen
Communications and Pappalardo Fellowships Program Administrator
MIT Department of Physics\n
----------Nominee Information------------\n
Nominee Gender:  %nomineeGender_req%\n
Nominee First Name:  %nomineeFName_req%\n
Nominee Last Name:  %nomineeLName_req%\n
Nominee Institution:  %nomineeInstitution_req%\n
Nominee Department:  %nomineeDept_req%\n
Nominee Field of Study:  %nomineeField_req%\n
Nominee Date of PhD:  %nomineePhd_req%\n
Nominee Address:  %nomineeAddy_req%\n
Nominee Phone:  %nomineePhone_req%\n
Nominee Email:  %nomineeEmail_req%\n
----------Nominator Information----------\n
Nominator Title:  %nominatorTitle_req%\n
Nominator First Name:  %nominatorFName_req%\n
Nominator Last Name:  %nominatorLName_req%\n
Nominator Institution:  %nominatorInstitution_req%\n
Nominator Department:  %nominatorDept_req%\n
Nominator Address:  %nominatorAddy_req%\n
Nominator Phone:  %nominatorPhone_req%\n
Nominator Email:  %nominatorEmail_req%\n
Please click this link to verify your nomination.  This will complete the nomination process. $verify\n
MSG;
/***************************************************************************/

function do_formmail(){
    global $autoresponder_enabled, $database_enabled;
    $form      = get_form_data();
    $errors    = check_form($form);
    if ($errors) {
        display_errors($errors);
        return;
    }
    send_mail($form);
    if ($autoresponder_enabled) 
        auto_respond($form);
    if ($database_enabled)
        save_form($form);
    redirect();
}

function redirect(){
    global $redirect_url;
    header("Location: $redirect_url");
    exit();
}



function save_form($vars){
    global $database_file, $database_fields;
    $f = fopen($database_file, 'a');
    if (!$f){
        die("Cannot open db file for save");
    }
    foreach ($vars as $k=>$v) {
        $vars[$k] = str_replace(array("|", ",", "\r","\n"), array(',', ' ',' ',' '), $v);
    }
    if (is_array($database_fields)) {
        $vars_orig = $vars; 
        $vars = array();
        foreach ($database_fields as $k)
            $vars[$k] = $vars_orig[$k];
    }
    $str = join(',', $vars);
    fwrite($f, $str."\n");
    fclose($f);
}

function auto_respond($vars){
    global $autoresponder_from, $autoresponder_message, $autoresponder_subject;
	global $nomineeFName, $nomineeLName, $nominatorFName, $nominatorLName, $nominatorEmail, $nominatorFullName, $nomineeFullName, $date_time; 
    /// replace all vars in message
    $msg = $autoresponder_message;
    preg_match_all('/%(.+?)%/', $msg, $out);
    $s_vars = $out[1]; //field list to substitute
    foreach ($s_vars as $k)
        $msg = str_replace("%$k%", $vars[$k], $msg);
    /// replace all vars in subject
    $subj = $autoresponder_subject;
    preg_match_all('/%(.+?)%/', $subj, $out);
    $s_vars = $out[1]; //field list to substitute
    foreach ($s_vars as $k)
        $subj = str_replace("%$k%", $vars[$k], $subj);
    //
    $_send_to = "$vars[nominatorFullName] <".$vars[nominatorEmail_req].">";
    $_send_from = $autoresponder_from;
    mail($_send_to, $subj, $msg, 'From: '.$_send_from);
}

function _build_fields($vars){
    $skip_fields = array(
        'subject');
    // order by numeric begin, if it exists
    $is_ordered = 0;
    foreach ($vars as $k=>$v) 
        if (in_array($k, $skip_fields)) unset($vars[$k]);

    $new_vars = array();
    foreach ($vars as $k=>$v){
        // remove _num, _reqnum, _req from end of field names
        $k = preg_replace('/_(req|num|reqnum)$/', '', $k);
        // check if the fields is ordered
        if (preg_match('/^\d+[ \:_-]/', $k)) $is_ordered++;
        $new_vars[$k] = $v;
    }
    $vars = $new_vars;

    $max_length = 10; // max length of key field 
    foreach ($vars as $k=>$v) {
        $klen = strlen($k);
        if (($klen > $max_length) && ($klen < 40))
            $max_length = $klen;
    }

    if ($is_ordered){
        ksort($vars);
        $new_vars = array();
        foreach ($vars as $k=>$v){
            //remove number from begin of fields
            $k = preg_replace('/^\d+[ \:_-]/', '', $k);
            $new_vars[$k] = $v;
        }
        $vars = $new_vars;
    }

    // make output text
    $out = "";
    foreach ($vars as $k=>$v){
        $k = str_replace('_', ' ', $k);
        $k = ucfirst($k);
        $len_diff = $max_length - strlen($k);
        if ($len_diff > 0) 
            $fill = str_repeat('.', $len_diff);
        else 
            $fill = '';
        $out .= $k."$fill...: $v\n\n";
    }
    return $out;
}


function send_mail($vars){
    global $send_to, $send_cc;
    global $subject;
    global $attachment_enabled;

//    $files = array(); //files (field names) to attach in mail
//    if (count($_FILES) && $attachment_enabled){
//        $files = array_keys($_FILES);
//    }

    // build mail
    $date_time = date('Y-m-d H:i:s');
    $mime_delimiter = "----=_NextPart_000_0001_".md5(time());
    $fields = _build_fields($vars);
    $mail = 
"This is a multi-part message in MIME format.
    
--$mime_delimiter
Content-type: text/plain
Content-Transfer-Encoding: 8bit
Content-Disposition: inline

MIT Pappalardo Nomination Form submitted:
$fields
--------------------
REMOTE IP : $_SERVER[REMOTE_ADDR]
DATE/TIME : $date_time
";

    if (count($files)){
        foreach ($files as $file){
            $file_name     = $_FILES[$file]['name'];
            $file_type     = $_FILES[$file]['type'];
            $file_tmp_name = $_FILES[$file]['tmp_name'];
            $file_cnt = "";
            $f=@fopen($file_tmp_name, "rb");
            if (!$f) 
                continue;
            while($f && !feof($f))
                $file_cnt .= fread($f, 4096);
            fclose($f);
            if (!strlen($file_type)) $file_type="applicaton/octet-stream";
            if ($file_type == 'application/x-msdownload')
                $file_type = "applicaton/octet-stream";

            $mail .= "\n--$mime_delimiter\n";
            $mail .= "Content-Type: $file_type;\n       name=\"$file_name\"\n";
            $mail .= "Content-Transfer-Encoding: base64\n";
            $mail .= "Content-Disposition: attachment;\n       filename=\"$file_name\"\n\n";
            $mail .= chunk_split(base64_encode($file_cnt));
        }
    }
    $mail .= "\n--$mime_delimiter--";


    //send to
    $_send_to = $send_to ? $send_to : "$vars[name_to] <".$vars[email_to].">";
    $_send_from = "$vars[nominatorFullName] <".$vars[nominatorEmail_req].">";
//    $_subject = $subject ? $subject : $vars['subject'];
	$_subject = "Pappalardo Nomination form $nomineeFName_req $nomineeLName_req :: $date_time";

    mail($_send_to, $_subject, $mail, 
    "MIME-Version: 1.0\nFrom: $_send_from\nContent-Type: multipart/mixed;\n    boundary=\"$mime_delimiter\"\n");

    foreach ($send_cc as $v){
      mail($v, $_subject, $mail, 
    "MIME-Version: 1.0\nFrom: $_send_from\nContent-Type: multipart/mixed;\n    boundary=\"$mime_delimiter\"\n");
    }
}

function get_form_data(){
    $vars = ($_SERVER['REQUEST_METHOD'] == 'GET') ? $_GET : $_POST;
    //strip spaces from all fields
    foreach ($vars as $k=>$v) $vars[$k] = trim($v);
    if (get_magic_quotes_gpc())
        foreach ($vars as $k=>$v) $vars[$k] = stripslashes($v);
        
    if (isset($vars['nominatorFName_req']))
        $vars['nominatorFName_req'] = preg_replace("/[^\w\d\t\., _-]/", "", $vars['nominatorFName_req']);
    if (isset($vars['nominatorLName_req']))
        $vars['nominatorLName_req'] = preg_replace("/[^\w\d\t\., _-]/", "", $vars['nominatorLName_req']);	
    if (isset($vars['nomineeFName_req']))
        $vars['nomineeFName_req'] = preg_replace("/[^\w\d\t\., _-]/", "", $vars['nomineeFName_req']);
    if (isset($vars['nomineeLName_req']))
        $vars['nomineeLName_req'] = preg_replace("/[^\w\d\t\., _-]/", "", $vars['nomineeLName_req']);	
    if (isset($vars['nominatorEmail_req']))
        $vars['nominatorEmail_req'] = preg_replace("/[^@\w\.\d_-]/", "", $vars['nominatorEmail_req']);
    if (isset($vars['subject']))
        $vars['subject'] = preg_replace("/[^\w\d\t \".,;:#\$%^&\*()+=`~\|_-]/", "", $vars['subject']);
    return $vars;
}

function check_form($vars){
    global $referrers;
    global $send_to;
    global $subject;

    $errors = array();

    // check from email set
    if (!strlen($vars['nominatorEmail_req'])){
        $errors[] = "Required field <b>Nominator Email address</b> empty";
    } else if (!check_email($vars['nominatorEmail_req'])){
        $errors[] = "Required field <b>Nominator Email address</b> incorrect";        
    }                 
    if (!strlen($send_to) && !strlen($vars['email_to'])){
        $errors[] = "<b>To Email</b> address empty (possible configuration error)";
    } else if (!strlen($send_to) && !check_email($vars['email_to'])){
        //if to email specified in form, check it and display error
        $errors[] = "<b>To Email address</b> incorrect";        
    }
    if (!strlen($vars['subject']) && !strlen($subject)){
        $errors[] = "<b>Subject</b> empty (possible configuration error)";
    }
    foreach ($vars as $k=>$v){
        // check for required fields (end with _req)
        if (preg_match('/^(.+?)_req$/i', $k, $m) && !strlen($v)){
            $field_name = ucfirst($m[1]);
            $errors[] = "Required field <b>$field_name</b> empty";
        }
        // check for number fields (end with _num)
        if (preg_match('/^(.+?)_num$/i', $k, $m) && strlen($v) && !is_numeric($v)){
            $field_name = ucfirst($m[1]);
            $errors[] = "Field <b>$field_name</b> must contain only digits or be empty";
        }
        // check for number & required fields (end with _reqnum)
        if (preg_match('/^(.+?)_reqnum$/i', $k, $m) && !is_numeric($v)){
            $field_name = ucfirst($m[1]);
            $errors[] = "Field <b>$field_name</b> must contain digits and only digits";
        }
    }

    //check referrer
    if (is_array($referrers) && count($referrers)){
        $ref = parse_url($_SERVER['HTTP_REFERER']);
        $host = $ref['host'];
        $host_found = 0;
        foreach ($referrers as $r){
            if (strstr($host, $r)) 
                $host_found++;
        }
        if (!$host_found){
            $errors[] = "Unknown Referrer: <b>$host</b>";
        }
    }
    return $errors;
}

function display_errors($errors){
$errors = '<li>' . join('<li>', $errors);
print <<<EOF
<html>
    <head><title>ERROR -- MIT PAPPALARDO FELLOWSHIP NOMINATION -- ERROR</title>
	<link href="http://web.mit.edu/physics/css/form.css" rel="stylesheet" type="text/css">
	</head>
	<div align="center"><br>
  
  <form name="error">
  
  <a href="http://web.mit.edu/">
<img src="http://web.mit.edu/graphicidentity/interface/mit-blackred-header1.gif"
alt="MIT" width="357" height="46" border="0" style="border:0px white;background-color:#fff;">
</a>

<p class="header_large">2019-2022 Pappalardo Fellowship Competition Nomination Form</p>

<p class="header_red">*AN ERROR OCCURED*</p>
<span class="errors" style="text-align:left;">$errors</span><br />
</div>
</form>
<p align=center>&nbsp;</p>
<div class="footer">
<span class="left">&nbsp;&copy; Copyright 2018 
<a href="http://web.mit.edu/physics/" target="_blank">MIT Department of Physics</a></span>
<span class="right">
Webmaster: <a href="mailto:kheatley@mit.edu" target="_blank">kheatley@mit.edu</a>&nbsp;
</span>

<br />
</div>

</html>
EOF;
}


/**
* Check email using regexes
* @param string email
* @return bool true if email valid, false if not
*/
function check_email($email) {
    #characters allowed on name: 0-9a-Z-._ on host: 0-9a-Z-. on between: @
    if (!preg_match('/^[0-9a-zA-Z\.\-\_]+\@[0-9a-zA-Z\.\-]+$/', $email))
        return false;

    #must start or end with alpha or num
    if ( preg_match('/^[^0-9a-zA-Z]|[^0-9a-zA-Z]$/', $email))
        return false;

    #name must end with alpha or num
    if (!preg_match('/([0-9a-zA-Z_]{1})\@./',$email) )                    
        return false;

    #host must start with alpha or num
    if (!preg_match('/.\@([0-9a-zA-Z_]{1})/',$email) )                    
        return false;

    #pair .- or -. or -- or .. not allowed
    if ( preg_match('/.\.\-.|.\-\..|.\.\..|.\-\-./',$email) )
        return false;

    #pair ._ or -_ or _. or _- or __ not allowed
    if ( preg_match('/.\.\_.|.\-\_.|.\_\..|.\_\-.|.\_\_./',$email) )
        return false;

    #host must end with '.' plus 2-5 alpha for TopLevelDomain
    if (!preg_match('/\.([a-zA-Z]{2,5})$/',$email) )
        return false;

    return true;
}

do_formmail();
?>
